/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.MyInputStream;
import cds.aladin.MyLabel;
import cds.aladin.ServerVizieR;
import cds.tools.CDSConstants;
import cds.tools.CDSMethods;
import cds.vizier.VizieRQuery;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.DataInputStream;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VizieRPanel
extends JPanel
implements CDSConstants {
    protected MyLabel titre = null;
    protected JTextField tauthor = new JTextField(15);
    protected JTextField ttarget = new JTextField(15);
    protected JTextField tradius = new JTextField(15);
    protected JComboBox unit = new JComboBox();
    protected JComboBox coordinate = null;
    protected DataInputStream vizierStream = null;
    protected int outputMode = 1;
    protected JList[] lk;
    private MyList resList = new MyList();
    protected JList resultat = new JList(this.resList);
    protected String target = null;
    protected String radius = null;
    protected int nSection;
    protected Aladin aladin;
    static final String SUBMIT = "SUBMIT";
    String DEFAULT_TITRE;
    String KEYWORD;
    static final String TITRE = "Copyright CDS, a changer";
    static final int DEFAULTROWS = 6;
    VizieRQuery vq = null;
    private ServerVizieR vizier;
    protected BorderLayout borderLayout1 = new BorderLayout();
    private int oc = 0;

    protected void setTitre(String target) {
        String s = null;
        String string = s = target == null ? this.DEFAULT_TITRE : "Click directly on the SUBMIT button to retrieve all VizieR catalogs around " + target + "\n or include constraints below to reduce the number of matching catalogs.";
        if (s != null) {
            this.titre.setText(s);
        } else {
            this.titre.setText("probleme");
        }
    }

    protected void createChaine() {
        VizieRPanel vizieRPanel = this;
        Chaine c = vizieRPanel.aladin.getChaine();
        this.DEFAULT_TITRE = c.getString("VZINFO2");
        this.KEYWORD = c.getString("VZKEYWORD");
    }

    public VizieRPanel(ServerVizieR vizier, int outputMode, boolean withparam, String target, String radius, int rows) {
        try {
            this.vizier = vizier;
            this.aladin = vizier.aladin;
            this.createChaine();
            this.outputMode = outputMode;
            this.vq = new VizieRQuery();
            this.vq.setGLU(this.aladin.glu);
            if (!this.vq.metaDataQuery() || this.vq.getNameKey().size() == 0) {
                System.err.println("VizieR meta query error " + (this.vq.getMetaError() == null ? "" : this.vq.getMetaError()));
            }
            this.nSection = this.vq.getNameKey().size();
            this.setLayout(this.borderLayout1);
            this.makeForm(withparam, target, radius, rows);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public VizieRQuery getVizieRQuery() {
        return this.vq;
    }

    protected static void makeCursor(Component c, int type) {
        while (c != null && !(c instanceof Frame)) {
            c = c.getParent();
        }
        if (c == null) {
            return;
        }
        ((Frame)c).setCursor(type == 1 ? 3 : (type == 2 ? 12 : (type == 3 ? 1 : (type == 4 ? 13 : (type == 5 ? 8 : (type == 6 ? 2 : 0))))));
    }

    private void waitCursor() {
        this.makeCursor(1);
    }

    private void defaultCursor() {
        this.makeCursor(0);
    }

    private void makeCursor(int c) {
        if (this.oc == c) {
            return;
        }
        VizieRPanel.makeCursor(this, c);
        if (this.resultat != null) {
            VizieRPanel.makeCursor(this.resultat, c);
        }
        VizieRPanel.makeCursor(this.tauthor, c);
        for (int i = 0; i < this.lk.length; ++i) {
            VizieRPanel.makeCursor(this.lk[i], c);
        }
        this.oc = c;
    }

    private String getSectionName(String s) {
        int i;
        char[] a = s.toCharArray();
        for (i = 0; i < a.length && a[i] != '.'; ++i) {
        }
        return i == a.length ? s : new String(a, i + 1, a.length - i - 1);
    }

    protected static void makeAdd(Container ct, Component c, String s) {
        try {
            ct.add(c, s);
        }
        catch (Error e) {
            ct.add(s, c);
        }
    }

    protected void makeForm(boolean withparam, String target, String radius, int rows) {
        JLabel label;
        GridBagLayout gridbag;
        JPanel byword = null;
        JPanel fields = null;
        JPanel parameters = null;
        JPanel lll = null;
        JPanel actions = null;
        GridBagConstraints c = new GridBagConstraints();
        this.titre = new MyLabel(this.DEFAULT_TITRE, 1, PLAIN);
        this.titre.setBackground(Aladin.BLUE);
        fields = new JPanel();
        fields.setLayout(new BorderLayout(3, 3));
        byword = new JPanel();
        byword.setBackground(Aladin.BLUE);
        byword.setLayout(new BorderLayout(3, 3));
        byword.setFont(BOLD);
        JPanel haut = new JPanel();
        haut.setBackground(Aladin.BLUE);
        haut.setLayout(new BorderLayout(3, 3));
        VizieRPanel.makeAdd(byword, new JLabel(this.KEYWORD), "West");
        VizieRPanel.makeAdd(byword, this.tauthor, "Center");
        if (target == null && radius == null) {
            parameters = new JPanel();
            gridbag = new GridBagLayout();
            parameters.setLayout(gridbag);
            parameters.setFont(BOLD);
            label = new JLabel("Target ");
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.1;
            c.anchor = 15;
            c.insets = new Insets(5, 5, 5, 5);
            gridbag.setConstraints(label, c);
            parameters.add(label);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.weighty = 0.1;
            c.ipadx = 50;
            c.fill = 2;
            c.insets = new Insets(5, 5, 5, 5);
            gridbag.setConstraints(this.ttarget, c);
            parameters.add(this.ttarget);
            this.coordinate = new JComboBox();
            this.coordinate.addItem("today");
            this.coordinate.addItem("J2000");
            this.coordinate.addItem("B1975");
            this.coordinate.addItem("B1950");
            this.coordinate.addItem("B1900");
            this.coordinate.addItem("B1875");
            this.coordinate.addItem("B1855");
            this.coordinate.addItem("Galactic");
            this.coordinate.addItem("Supergal.");
            this.coordinate.setSelectedItem("J2000");
            c = new GridBagConstraints();
            c.gridx = 6;
            c.gridy = 0;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.1;
            c.insets = new Insets(5, 5, 5, 5);
            gridbag.setConstraints(this.coordinate, c);
            parameters.add(this.coordinate);
            label = new JLabel("Radius ");
            c = new GridBagConstraints();
            c.gridx = 8;
            c.gridy = 0;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.1;
            c.anchor = 15;
            c.insets = new Insets(5, 5, 5, 5);
            gridbag.setConstraints(label, c);
            parameters.add(label);
            c = new GridBagConstraints();
            c.gridx = 10;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.1;
            c.weighty = 0.1;
            c.insets = new Insets(5, 5, 5, 5);
            gridbag.setConstraints(this.tradius, c);
            parameters.add(this.tradius);
            this.tradius.setText("10.0");
            this.unit = new JComboBox();
            this.unit.addItem("deg");
            this.unit.addItem("arcmin");
            this.unit.addItem("arcsec");
            this.unit.setSelectedItem("arcmin");
            c = new GridBagConstraints();
            c.gridx = 11;
            c.gridy = 0;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 0.1;
            c.insets = new Insets(5, 5, 5, 5);
            gridbag.setConstraints(this.unit, c);
            parameters.add(this.unit);
        } else {
            if (radius != null) {
                this.tradius.setText(radius);
            }
            if (target != null) {
                this.ttarget.setText(target);
            }
        }
        lll = new JPanel();
        gridbag = new GridBagLayout();
        lll.setLayout(gridbag);
        lll.setFont(BOLD);
        lll.setBackground(Aladin.BLUE);
        c = new GridBagConstraints();
        this.lk = new JList[this.nSection];
        label = null;
        for (int j = 0; j < this.nSection; ++j) {
            label = new JLabel();
            c = new GridBagConstraints();
            c.gridx = j;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 0.1;
            c.weighty = 0.1;
            c.fill = 2;
            c.anchor = 15;
            c.insets = new Insets(0, 0, 0, 0);
            gridbag.setConstraints(label, c);
            label.setText(this.getSectionName((String)this.vq.getNameKey().elementAt(j)));
            lll.add(label);
            Vector v = (Vector)this.vq.gethKey().get(this.vq.getNameKey().elementAt(j));
            if (rows < 0) {
                this.lk[j] = new JList(v);
            } else {
                this.lk[j] = new JList(v);
                this.lk[j].setVisibleRowCount(rows);
                this.lk[j].setSelectionMode(2);
                this.lk[j].addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        VizieRPanel.this.vizier.resetCatalog();
                    }
                });
            }
            c = new GridBagConstraints();
            c.gridx = j;
            c.gridy = 1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.insets = new Insets(0, 2, 0, 2);
            JScrollPane jp = new JScrollPane(this.lk[j]);
            gridbag.setConstraints(jp, c);
            lll.add(jp);
        }
        actions = new JPanel();
        actions.setBackground(Aladin.BLUE);
        actions.setLayout(new FlowLayout(2));
        actions.setFont(BOLD);
        VizieRPanel.makeAdd(haut, this.titre, "North");
        VizieRPanel.makeAdd(haut, byword, "Center");
        if (target == null && radius == null && withparam) {
            VizieRPanel.makeAdd(haut, parameters, "South");
        }
        JPanel bas = new JPanel();
        bas.setBackground(Aladin.BLUE);
        bas.setLayout(new BorderLayout(3, 3));
        VizieRPanel.makeAdd(bas, lll, "Center");
        VizieRPanel.makeAdd(bas, actions, "South");
        VizieRPanel.makeAdd(this, haut, "North");
        VizieRPanel.makeAdd(this, bas, "Center");
        this.setTitre(this.target);
    }

    public static void resetList(JList l) {
        l.clearSelection();
    }

    public void resetAll() {
        this.tauthor.setText("");
        if (this.ttarget != null) {
            this.ttarget.setText("");
            this.tradius.setText("10.0");
        }
        for (int i = 0; i < this.nSection; ++i) {
            VizieRPanel.resetList(this.lk[i]);
        }
    }

    public boolean submit() {
        StringBuffer extra = new StringBuffer();
        this.waitCursor();
        for (int j = 0; j < this.nSection; ++j) {
            int[] selected = this.lk[j].getSelectedIndices();
            for (int i = 0; i < selected.length; ++i) {
                CDSMethods.append(extra, (String)this.vq.getNameKey().elementAt(j), (String)this.lk[j].getModel().getElementAt(selected[i]));
            }
        }
        boolean res = this.vq.submit(this.ttarget.getText(), this.tradius.getText(), (String)this.unit.getSelectedItem(), this.tauthor.getText(), extra.toString(), this.outputMode, this.resList.getList());
        this.defaultCursor();
        return res;
    }

    public boolean submit(String a, String b) {
        StringBuffer extra = new StringBuffer();
        this.waitCursor();
        for (int j = 0; j < this.nSection; ++j) {
            int[] selected = this.lk[j].getSelectedIndices();
            for (int i = 0; i < selected.length; ++i) {
                CDSMethods.append(extra, (String)this.vq.getNameKey().elementAt(j), (String)this.lk[j].getModel().getElementAt(selected[i]));
            }
        }
        boolean res = this.vq.submit(a, b, (String)this.unit.getSelectedItem(), (String)this.coordinate.getSelectedItem(), this.tauthor.getText(), extra.toString(), this.outputMode, this.resList.getList());
        this.defaultCursor();
        return res;
    }

    public String[] getSelection(String type) {
        try {
            if (type.compareTo("MISSION") == 0) {
                String[] temp = new String[this.vq.getvArchives().size()];
                for (int i = 0; i < this.vq.getvArchives().size(); ++i) {
                    temp[i] = new String((String)this.vq.getvArchives().elementAt(i));
                }
                return temp;
            }
            if (type.compareTo("SURVEY") == 0) {
                String[] temp = new String[this.vq.getvSurveys().size()];
                for (int i = 0; i < this.vq.getvSurveys().size(); ++i) {
                    temp[i] = new String((String)this.vq.getvSurveys().elementAt(i));
                }
                return temp;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println(e);
        }
        return null;
    }

    public MyInputStream getResultStream() {
        return this.vq.getResultStream();
    }

    public JList getResultList() {
        return this.resultat;
    }

    public Vector getResultVector() {
        return this.resList.getList();
    }

    public JTextField getAuthor() {
        return this.tauthor;
    }

    public JList getList(int i) {
        return this.lk[i];
    }

    public int getListCount() {
        return this.lk.length;
    }

    public void setLabel(String label) {
        this.titre.setText(label);
    }

    class MyList
    implements ListModel {
        private Vector v = new Vector();

        MyList() {
        }

        protected void initList(Vector v) {
            this.v = (Vector)v.clone();
        }

        protected Vector getList() {
            return this.v;
        }

        protected void add(String s) {
            this.v.add(s);
        }

        public Object getElementAt(int index) {
            return this.v.elementAt(index);
        }

        @Override
        public int getSize() {
            return this.v.size();
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

